/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.http;

import com.stackhawk.http.HttpRequestContext;
import com.stackhawk.http.HttpServer;
import com.stackhawk.http.HttpServerConfig;
import com.stackhawk.http.NotFoundHandler;
import com.stackhawk.http.Router;
import com.stackhawk.http.ServerSSLConfig;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.net.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003*\u0001\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stackhawk/http/HttpServer;", "", "config", "Lcom/stackhawk/http/HttpServerConfig;", "(Lcom/stackhawk/http/HttpServerConfig;)V", "bossGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "handler", "com/stackhawk/http/HttpServer$handler$1", "Lcom/stackhawk/http/HttpServer$handler$1;", "<set-?>", "", "port", "getPort", "()I", "workerGroup", "start", "", "stop", "Companion", "talon-http"})
public final class HttpServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpServerConfig config;
    private int port;
    @NotNull
    private final NioEventLoopGroup bossGroup;
    @NotNull
    private final NioEventLoopGroup workerGroup;
    @NotNull
    private final handler.1 handler;

    public HttpServer(@NotNull HttpServerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        this.handler = new ChannelInitializer<SocketChannel>(this){
            final /* synthetic */ HttpServer this$0;
            {
                this.this$0 = $receiver;
            }

            protected void initChannel(@NotNull SocketChannel ch) throws Exception {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ServerSSLConfig serverSSLConfig = HttpServer.access$getConfig$p(this.this$0).getSslConfig();
                if (serverSSLConfig != null) {
                    ServerSSLConfig sslConfig = serverSSLConfig;
                    boolean bl = false;
                    SslContext sslCtx = SslContextBuilder.forServer((InputStream)sslConfig.getCertificateFile(), (InputStream)sslConfig.getKeyfile()).build();
                    ch.pipeline().addLast("ssl", (ChannelHandler)sslCtx.newHandler(ch.alloc()));
                }
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(10240000), new ChunkedWriteHandler()};
                ch.pipeline().addLast(channelHandlerArray);
                Collection $this$toTypedArray$iv = (Collection)HttpServer.access$getConfig$p(this.this$0).getHandlers().invoke();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                channelHandlerArray = thisCollection$iv.toArray(new ChannelHandler[0]);
                ch.pipeline().addLast(Arrays.copyOf(channelHandlerArray, channelHandlerArray.length));
                channelHandlerArray = new ChannelHandler[]{new NotFoundHandler()};
                ch.pipeline().addLast(channelHandlerArray);
            }
        };
    }

    public final int getPort() {
        return this.port;
    }

    public final void start() {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this.handler).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture channelFuture = b.bind(this.config.getHost(), this.config.getPort()).sync();
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"sync(...)");
        ChannelFuture f = channelFuture;
        Channel chan = f.channel();
        SocketAddress socketAddr = chan.localAddress();
        this.port = socketAddr instanceof InetSocketAddress ? ((InetSocketAddress)socketAddr).getPort() : 0;
        Companion.launchThread((Function0<Unit>)((Function0)new Function0<Unit>(chan, this){
            final /* synthetic */ Channel $chan;
            final /* synthetic */ HttpServer this$0;
            {
                this.$chan = $chan;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    this.$chan.closeFuture().sync();
                }
                finally {
                    this.this$0.stop();
                }
            }
        }));
    }

    public final void stop() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    public static final /* synthetic */ HttpServerConfig access$getConfig$p(HttpServer $this) {
        return $this.config;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ1\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012JA\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0019\b\u0002\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J2\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001cJ(\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010#\u001a\u00020$J\u0014\u0010%\u001a\u00020\u00042\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040'J?\u0010(\u001a\u00020\u00162\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0017\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J$\u0010)\u001a\u00020\u0004*\u00020\u00112\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180+0*J5\u0010,\u001a\u00020\u0004*\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J\n\u00102\u001a\u00020/*\u000203J\n\u00104\u001a\u00020\u0018*\u000203J\u0012\u00105\u001a\u00020$*\u00020\u00112\u0006\u00106\u001a\u000207J\n\u00108\u001a\u00020\u0004*\u00020-J\n\u00109\u001a\u00020\u0004*\u00020-J%\u0010:\u001a\u00020\u0004*\u00020-2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J\u0012\u0010;\u001a\u00020\u0004*\u00020-2\u0006\u0010.\u001a\u00020/J5\u0010;\u001a\u00020\u0004*\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J\u0012\u0010;\u001a\u00020\u0004*\u00020-2\u0006\u0010.\u001a\u00020\u0018J5\u0010;\u001a\u00020\u0004*\u00020-2\u0006\u0010.\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J/\u0010<\u001a\u00020\u0004*\u00020-2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J=\u0010=\u001a\u00020\u0004*\u00020-2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J=\u0010=\u001a\u00020\u0004*\u00020-2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u00182\u0006\u00100\u001a\u0002012\u0019\b\u0002\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0002\b\u0012J\n\u0010>\u001a\u00020?*\u00020\u0006\u00a8\u0006@"}, d2={"Lcom/stackhawk/http/HttpServer$Companion;", "", "()V", "checkKeepAlive", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channelFuture", "Lio/netty/channel/ChannelFuture;", "createEmptyResponse", "Lio/netty/handler/codec/http/DefaultFullHttpResponse;", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "version", "Lio/netty/handler/codec/http/HttpVersion;", "headers", "Lkotlin/Function1;", "Lio/netty/handler/codec/http/HttpHeaders;", "Lkotlin/ExtensionFunctionType;", "createWebApp", "Lcom/stackhawk/http/HttpServer;", "port", "", "host", "", "sslConfig", "Lcom/stackhawk/http/ServerSSLConfig;", "routing", "Lcom/stackhawk/http/Router;", "router", "internalError", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "cause", "", "returnError", "", "launchThread", "block", "Lkotlin/Function0;", "startWebApp", "addHeaders", "", "Lkotlin/Pair;", "badRequestWithContent", "Lcom/stackhawk/http/HttpRequestContext;", "content", "", "contentType", "Lorg/apache/hc/core5/http/ContentType;", "bodyBytes", "Lio/netty/handler/codec/http/FullHttpRequest;", "bodyText", "hasHeader", "name", "Lio/netty/util/AsciiString;", "methodNotAllowed", "notFound", "okNoContent", "okWithContent", "responseNoContent", "responseWithContent", "uriBuilder", "Lorg/apache/hc/core5/net/URIBuilder;", "talon-http"})
    @SourceDebugExtension(value={"SMAP\nHttpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpServer.kt\ncom/stackhawk/http/HttpServer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,411:1\n1#2:412\n1855#3,2:413\n*S KotlinDebug\n*F\n+ 1 HttpServer.kt\ncom/stackhawk/http/HttpServer$Companion\n*L\n237#1:413,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpServer createWebApp(int port, @NotNull String host, @Nullable ServerSSLConfig sslConfig, @Nullable Router router) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Function0 handlersFn2 = (Function0)new Function0<List<? extends ChannelHandler>>(router){
                final /* synthetic */ Router $router;
                {
                    this.$router = $router;
                    super(0);
                }

                @NotNull
                public final List<ChannelHandler> invoke() {
                    Object object = this.$router;
                    if (object == null || (object = ((Router)object).handlers()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    return object;
                }
            };
            HttpServerConfig serverConfig = new HttpServerConfig(port, host, sslConfig, (Function0<? extends List<? extends ChannelHandler>>)handlersFn2);
            return new HttpServer(serverConfig);
        }

        public static /* synthetic */ HttpServer createWebApp$default(Companion companion, int n, String string, ServerSSLConfig serverSSLConfig, Router router, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                string = "localhost";
            }
            if ((n2 & 4) != 0) {
                serverSSLConfig = null;
            }
            if ((n2 & 8) != 0) {
                router = null;
            }
            return companion.createWebApp(n, string, serverSSLConfig, router);
        }

        @NotNull
        public final HttpServer createWebApp(int port, @NotNull String host, @Nullable ServerSSLConfig sslConfig, @NotNull Function1<? super Router, Unit> routing) {
            Router router;
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(routing, (String)"routing");
            Router $this$createWebApp_u24lambda_u240 = router = new Router();
            boolean bl = false;
            routing.invoke((Object)$this$createWebApp_u24lambda_u240);
            return this.createWebApp(port, host, sslConfig, router);
        }

        public static /* synthetic */ HttpServer createWebApp$default(Companion companion, int n, String string, ServerSSLConfig serverSSLConfig, Function1 function1, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                string = "localhost";
            }
            if ((n2 & 4) != 0) {
                serverSSLConfig = null;
            }
            if ((n2 & 8) != 0) {
                function1 = createWebApp.1.INSTANCE;
            }
            return companion.createWebApp(n, string, serverSSLConfig, (Function1<? super Router, Unit>)function1);
        }

        public final int startWebApp(int port, @NotNull String host, @Nullable ServerSSLConfig sslConfig, @NotNull Function1<? super Router, Unit> routing) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(routing, (String)"routing");
            HttpServer httpServer = this.createWebApp(port, host, sslConfig, routing);
            httpServer.start();
            return httpServer.getPort();
        }

        public static /* synthetic */ int startWebApp$default(Companion companion, int n, String string, ServerSSLConfig serverSSLConfig, Function1 function1, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                string = "localhost";
            }
            if ((n2 & 4) != 0) {
                serverSSLConfig = null;
            }
            return companion.startWebApp(n, string, serverSSLConfig, (Function1<? super Router, Unit>)function1);
        }

        public final void launchThread(@NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            new Thread(() -> Companion.launchThread$lambda$1(block)).start();
        }

        public final void notFound(@NotNull HttpRequestContext $this$notFound) {
            Intrinsics.checkNotNullParameter((Object)$this$notFound, (String)"<this>");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
            HttpVersion httpVersion = $this$notFound.getRequest().protocolVersion();
            Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"protocolVersion(...)");
            DefaultFullHttpResponse resp = com.stackhawk.http.HttpServer$Companion.createEmptyResponse$default(this, httpResponseStatus, httpVersion, null, 4, null);
            ChannelFuture future = $this$notFound.getCtx().writeAndFlush((Object)resp);
            HttpRequest httpRequest = (HttpRequest)$this$notFound.getRequest();
            Intrinsics.checkNotNull((Object)future);
            this.checkKeepAlive(httpRequest, future);
        }

        public final void okWithContent(@NotNull HttpRequestContext $this$okWithContent, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)$this$okWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            String string = content;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ContentType contentType = ContentType.TEXT_PLAIN;
            Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"TEXT_PLAIN");
            this.responseWithContent($this$okWithContent, httpResponseStatus, byArray, contentType, (Function1<? super HttpHeaders, Unit>)((Function1)okWithContent.1.INSTANCE));
        }

        public final void okWithContent(@NotNull HttpRequestContext $this$okWithContent, @NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)$this$okWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            ContentType contentType = ContentType.TEXT_PLAIN;
            Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"TEXT_PLAIN");
            this.responseWithContent($this$okWithContent, httpResponseStatus, content, contentType, (Function1<? super HttpHeaders, Unit>)((Function1)okWithContent.2.INSTANCE));
        }

        public final void okWithContent(@NotNull HttpRequestContext $this$okWithContent, @NotNull String content, @NotNull ContentType contentType, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$okWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            String string = content;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.responseWithContent($this$okWithContent, httpResponseStatus, byArray, contentType, headers);
        }

        public static /* synthetic */ void okWithContent$default(Companion companion, HttpRequestContext httpRequestContext, String string, ContentType contentType, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = okWithContent.3.INSTANCE;
            }
            companion.okWithContent(httpRequestContext, string, contentType, (Function1<? super HttpHeaders, Unit>)function1);
        }

        public final void okWithContent(@NotNull HttpRequestContext $this$okWithContent, @NotNull byte[] content, @NotNull ContentType contentType, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$okWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            this.responseWithContent($this$okWithContent, httpResponseStatus, content, contentType, headers);
        }

        public static /* synthetic */ void okWithContent$default(Companion companion, HttpRequestContext httpRequestContext, byte[] byArray, ContentType contentType, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = okWithContent.4.INSTANCE;
            }
            companion.okWithContent(httpRequestContext, byArray, contentType, (Function1<? super HttpHeaders, Unit>)function1);
        }

        public final void badRequestWithContent(@NotNull HttpRequestContext $this$badRequestWithContent, @NotNull byte[] content, @NotNull ContentType contentType, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$badRequestWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_REQUEST;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"BAD_REQUEST");
            this.responseWithContent($this$badRequestWithContent, httpResponseStatus, content, contentType, headers);
        }

        public static /* synthetic */ void badRequestWithContent$default(Companion companion, HttpRequestContext httpRequestContext, byte[] byArray, ContentType contentType, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = badRequestWithContent.1.INSTANCE;
            }
            companion.badRequestWithContent(httpRequestContext, byArray, contentType, (Function1<? super HttpHeaders, Unit>)function1);
        }

        public final void responseWithContent(@NotNull HttpRequestContext $this$responseWithContent, @NotNull HttpResponseStatus status, @NotNull String content, @NotNull ContentType contentType, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$responseWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            String string = content;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.responseWithContent($this$responseWithContent, status, byArray, contentType, headers);
        }

        public static /* synthetic */ void responseWithContent$default(Companion companion, HttpRequestContext httpRequestContext, HttpResponseStatus httpResponseStatus, String string, ContentType contentType, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = responseWithContent.1.INSTANCE;
            }
            companion.responseWithContent(httpRequestContext, httpResponseStatus, string, contentType, (Function1<? super HttpHeaders, Unit>)function1);
        }

        public final void responseWithContent(@NotNull HttpRequestContext $this$responseWithContent, @NotNull HttpResponseStatus status, @NotNull byte[] content, @NotNull ContentType contentType, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$responseWithContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            ByteBuf outBuf = $this$responseWithContent.getCtx().alloc().buffer(content.length);
            outBuf.writeBytes(content);
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse($this$responseWithContent.getRequest().protocolVersion(), status, outBuf);
            HttpHeaders $this$responseWithContent_u24lambda_u242 = resp.headers();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$responseWithContent_u24lambda_u242);
            headers.invoke((Object)$this$responseWithContent_u24lambda_u242);
            HttpHeaders httpHeaders = resp.headers();
            Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"headers(...)");
            AsciiString asciiString = HttpHeaderNames.CONTENT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)asciiString, (String)"CONTENT_TYPE");
            if (!this.hasHeader(httpHeaders, asciiString)) {
                resp.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
            }
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)outBuf.readableBytes());
            ChannelFuture future = $this$responseWithContent.getCtx().writeAndFlush((Object)resp);
            HttpRequest httpRequest = (HttpRequest)$this$responseWithContent.getRequest();
            Intrinsics.checkNotNull((Object)future);
            this.checkKeepAlive(httpRequest, future);
        }

        public static /* synthetic */ void responseWithContent$default(Companion companion, HttpRequestContext httpRequestContext, HttpResponseStatus httpResponseStatus, byte[] byArray, ContentType contentType, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = responseWithContent.2.INSTANCE;
            }
            companion.responseWithContent(httpRequestContext, httpResponseStatus, byArray, contentType, (Function1<? super HttpHeaders, Unit>)function1);
        }

        @NotNull
        public final byte[] bodyBytes(@NotNull FullHttpRequest $this$bodyBytes) {
            Intrinsics.checkNotNullParameter((Object)$this$bodyBytes, (String)"<this>");
            ByteBuf byteBuf = $this$bodyBytes.content();
            int requestBodySize = byteBuf.readableBytes();
            byte[] inBuf = new byte[requestBodySize];
            byteBuf.readBytes(inBuf);
            return inBuf;
        }

        @NotNull
        public final String bodyText(@NotNull FullHttpRequest $this$bodyText) {
            Intrinsics.checkNotNullParameter((Object)$this$bodyText, (String)"<this>");
            return new String(this.bodyBytes($this$bodyText), Charsets.UTF_8);
        }

        public final void responseNoContent(@NotNull HttpRequestContext $this$responseNoContent, @NotNull HttpResponseStatus status, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$responseNoContent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            HttpVersion httpVersion = $this$responseNoContent.getRequest().protocolVersion();
            Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"protocolVersion(...)");
            DefaultFullHttpResponse resp = this.createEmptyResponse(status, httpVersion, headers);
            ChannelFuture future = $this$responseNoContent.getCtx().writeAndFlush((Object)resp);
            HttpRequest httpRequest = (HttpRequest)$this$responseNoContent.getRequest();
            Intrinsics.checkNotNull((Object)future);
            this.checkKeepAlive(httpRequest, future);
        }

        public static /* synthetic */ void responseNoContent$default(Companion companion, HttpRequestContext httpRequestContext, HttpResponseStatus httpResponseStatus, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus2, (String)"OK");
                httpResponseStatus = httpResponseStatus2;
            }
            if ((n & 2) != 0) {
                function1 = responseNoContent.1.INSTANCE;
            }
            companion.responseNoContent(httpRequestContext, httpResponseStatus, (Function1<? super HttpHeaders, Unit>)function1);
        }

        public final void okNoContent(@NotNull HttpRequestContext $this$okNoContent, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$okNoContent, (String)"<this>");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"OK");
            this.responseNoContent($this$okNoContent, httpResponseStatus, headers);
        }

        public static /* synthetic */ void okNoContent$default(Companion companion, HttpRequestContext httpRequestContext, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = okNoContent.1.INSTANCE;
            }
            companion.okNoContent(httpRequestContext, (Function1<? super HttpHeaders, Unit>)function1);
        }

        public final void methodNotAllowed(@NotNull HttpRequestContext $this$methodNotAllowed) {
            Intrinsics.checkNotNullParameter((Object)$this$methodNotAllowed, (String)"<this>");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.METHOD_NOT_ALLOWED;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"METHOD_NOT_ALLOWED");
            HttpVersion httpVersion = $this$methodNotAllowed.getRequest().protocolVersion();
            Intrinsics.checkNotNullExpressionValue((Object)httpVersion, (String)"protocolVersion(...)");
            DefaultFullHttpResponse resp = com.stackhawk.http.HttpServer$Companion.createEmptyResponse$default(this, httpResponseStatus, httpVersion, null, 4, null);
            ChannelFuture future = $this$methodNotAllowed.getCtx().writeAndFlush((Object)resp);
            HttpRequest httpRequest = (HttpRequest)$this$methodNotAllowed.getRequest();
            Intrinsics.checkNotNull((Object)future);
            this.checkKeepAlive(httpRequest, future);
        }

        public final void addHeaders(@NotNull HttpHeaders $this$addHeaders, @NotNull List<Pair<String, String>> headers) {
            Intrinsics.checkNotNullParameter((Object)$this$addHeaders, (String)"<this>");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Iterable $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                $this$addHeaders.add(name, (Object)value);
            }
        }

        public final boolean hasHeader(@NotNull HttpHeaders $this$hasHeader, @NotNull AsciiString name) {
            Intrinsics.checkNotNullParameter((Object)$this$hasHeader, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return $this$hasHeader.contains((CharSequence)name) || $this$hasHeader.contains((CharSequence)name.toLowerCase());
        }

        @NotNull
        public final URIBuilder uriBuilder(@NotNull HttpRequest $this$uriBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$uriBuilder, (String)"<this>");
            return new URIBuilder($this$uriBuilder.uri());
        }

        public final void internalError(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause, @NotNull HttpRequest request, boolean returnError) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (returnError) {
                String string = ExceptionsKt.stackTraceToString((Throwable)cause);
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] stacktraceBytes = byArray;
                pair = TuplesKt.to((Object)Unpooled.buffer().writeBytes(stacktraceBytes), (Object)stacktraceBytes.length);
            } else {
                pair = TuplesKt.to((Object)Unpooled.EMPTY_BUFFER, (Object)0);
            }
            Pair pair2 = pair;
            ByteBuf body = (ByteBuf)pair2.component1();
            int size = ((Number)pair2.component2()).intValue();
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, body);
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)size);
            ChannelFuture future = ctx.writeAndFlush((Object)resp);
            Intrinsics.checkNotNull((Object)future);
            this.checkKeepAlive(request, future);
        }

        public static /* synthetic */ void internalError$default(Companion companion, ChannelHandlerContext channelHandlerContext, Throwable throwable, HttpRequest httpRequest, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.internalError(channelHandlerContext, throwable, httpRequest, bl);
        }

        public final void checkKeepAlive(@NotNull HttpRequest request, @NotNull ChannelFuture channelFuture) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)channelFuture, (String)"channelFuture");
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            if (!keepAlive) {
                channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }

        @NotNull
        public final DefaultFullHttpResponse createEmptyResponse(@NotNull HttpResponseStatus status, @NotNull HttpVersion version, @NotNull Function1<? super HttpHeaders, Unit> headers) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(version, status);
            HttpHeaders $this$createEmptyResponse_u24lambda_u244 = resp.headers();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$createEmptyResponse_u24lambda_u244);
            headers.invoke((Object)$this$createEmptyResponse_u24lambda_u244);
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            return resp;
        }

        public static /* synthetic */ DefaultFullHttpResponse createEmptyResponse$default(Companion companion, HttpResponseStatus httpResponseStatus, HttpVersion httpVersion, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = createEmptyResponse.1.INSTANCE;
            }
            return companion.createEmptyResponse(httpResponseStatus, httpVersion, (Function1<? super HttpHeaders, Unit>)function1);
        }

        private static final void launchThread$lambda$1(Function0 $block) {
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            $block.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

