/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.http;

import com.stackhawk.http.HttpRequestContext;
import com.stackhawk.http.HttpServer;
import com.stackhawk.http.Route;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/stackhawk/http/RouteHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/http/FullHttpRequest;", "route", "Lcom/stackhawk/http/Route;", "(Lcom/stackhawk/http/Route;)V", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "release", "", "request", "getRoute", "()Lcom/stackhawk/http/Route;", "channelRead0", "", "exceptionCaught", "cause", "", "handleRequest", "talon-http"})
public final class RouteHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @NotNull
    private final Route route;
    private FullHttpRequest request;
    private ChannelHandlerContext ctx;
    private boolean release;

    public RouteHandler(@NotNull Route route) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        super(false);
        this.route = route;
        this.release = true;
    }

    @NotNull
    public final Route getRoute() {
        return this.route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.ctx = ctx;
        try {
            this.handleRequest(request);
        }
        catch (Exception e) {
            HttpServer.Companion.internalError(ctx, e, (HttpRequest)request, true);
        }
        finally {
            if (this.release) {
                ReferenceCountUtil.release((Object)request);
            }
        }
    }

    private final void handleRequest(FullHttpRequest request) {
        Regex regex = new Regex(this.route.getPath());
        String string = HttpServer.Companion.uriBuilder((HttpRequest)request).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        boolean match = regex.matches((CharSequence)string);
        if (match) {
            if (Intrinsics.areEqual((Object)request.method(), (Object)this.route.getMethod())) {
                this.request = request;
                Function1<HttpRequestContext, Unit> function1 = this.route.getHandler();
                ChannelHandlerContext channelHandlerContext = this.ctx;
                if (channelHandlerContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
                    channelHandlerContext = null;
                }
                function1.invoke((Object)HttpRequestContext.Companion.requestContext(channelHandlerContext, request));
            } else {
                ChannelHandlerContext channelHandlerContext = this.ctx;
                if (channelHandlerContext == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
                    channelHandlerContext = null;
                }
                HttpServer.Companion.methodNotAllowed(HttpRequestContext.Companion.ctx((Pair<? extends ChannelHandlerContext, ? extends FullHttpRequest>)TuplesKt.to((Object)channelHandlerContext, (Object)request)));
            }
        } else {
            this.release = false;
            ChannelHandlerContext channelHandlerContext = this.ctx;
            if (channelHandlerContext == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ctx");
                channelHandlerContext = null;
            }
            channelHandlerContext.fireChannelRead((Object)request);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        FullHttpRequest fullHttpRequest = this.request;
        if (fullHttpRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"request");
            fullHttpRequest = null;
        }
        HttpServer.Companion.internalError(ctx, cause, (HttpRequest)fullHttpRequest, true);
    }
}

