/*
 * Decompiled with CFR 0.152.
 */
package com.stackhawk.ssl;

import com.stackhawk.ssl.SelfSignedTrustManager;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 BI\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002R\u001d\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0011\u001a\u0004\b\u0013\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u0004\u0018\u00010\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u001a\u0010\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/stackhawk/ssl/CustomTrustManagerHelper;", "", "path", "", "isSelfSignedAllowed", "", "trustStorePath", "trustStoreType", "trustStorePassword", "defaultTrustManagerFactory", "Ljavax/net/ssl/TrustManagerFactory;", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/net/ssl/TrustManagerFactory;)V", "customTrustManager", "Ljavax/net/ssl/X509TrustManager;", "getCustomTrustManager", "()Ljavax/net/ssl/X509TrustManager;", "customTrustManager$delegate", "Lkotlin/Lazy;", "defaultTrustManager", "getDefaultTrustManager", "defaultTrustManager$delegate", "trustManagers", "", "getTrustManagers", "()Ljava/util/List;", "trustStoreTrustManager", "getTrustStoreTrustManager", "trustStoreTrustManager$delegate", "buildTrustManagers", "", "loadTrustStoreFromFile", "Ljava/security/KeyStore;", "Companion", "talon-http"})
@SourceDebugExtension(value={"SMAP\nCustomTrustManagerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomTrustManagerHelper.kt\ncom/stackhawk/ssl/CustomTrustManagerHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public final class CustomTrustManagerHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String path;
    private final boolean isSelfSignedAllowed;
    @Nullable
    private final String trustStorePath;
    @Nullable
    private final String trustStoreType;
    @Nullable
    private final String trustStorePassword;
    @NotNull
    private final TrustManagerFactory defaultTrustManagerFactory;
    @NotNull
    private final List<X509TrustManager> trustManagers;
    @NotNull
    private final Lazy trustStoreTrustManager$delegate;
    @NotNull
    private final Lazy customTrustManager$delegate;
    @NotNull
    private final Lazy defaultTrustManager$delegate;
    private static final Logger logger = LogManager.getLogger(Companion.getClass());

    public CustomTrustManagerHelper(@Nullable String path, boolean isSelfSignedAllowed, @Nullable String trustStorePath, @Nullable String trustStoreType, @Nullable String trustStorePassword, @NotNull TrustManagerFactory defaultTrustManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)defaultTrustManagerFactory, (String)"defaultTrustManagerFactory");
        this.path = path;
        this.isSelfSignedAllowed = isSelfSignedAllowed;
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = trustStorePassword;
        this.defaultTrustManagerFactory = defaultTrustManagerFactory;
        this.trustManagers = new ArrayList();
        this.trustStoreTrustManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<X509TrustManager>(this){
            final /* synthetic */ CustomTrustManagerHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final X509TrustManager invoke() {
                X509TrustManager x509TrustManager;
                KeyStore keyStore = CustomTrustManagerHelper.access$loadTrustStoreFromFile(this.this$0);
                if (keyStore != null) {
                    KeyStore keyStore2 = keyStore;
                    CustomTrustManagerHelper customTrustManagerHelper = this.this$0;
                    KeyStore keyStore3 = keyStore2;
                    boolean bl = false;
                    CustomTrustManagerHelper.access$getDefaultTrustManagerFactory$p(customTrustManagerHelper).init(keyStore3);
                    TrustManager[] trustManagerArray = CustomTrustManagerHelper.access$getDefaultTrustManagerFactory$p(customTrustManagerHelper).getTrustManagers();
                    Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getTrustManagers(...)");
                    x509TrustManager = CustomTrustManagerHelper.Companion.getX509Manager(trustManagerArray);
                } else {
                    x509TrustManager = null;
                }
                return x509TrustManager;
            }
        }));
        this.customTrustManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<X509TrustManager>(this){
            final /* synthetic */ CustomTrustManagerHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final X509TrustManager invoke() {
                String string;
                String string2 = CustomTrustManagerHelper.access$getPath$p(this.this$0);
                if (string2 == null) return null;
                String it = string = string2;
                boolean bl = false;
                if (((CharSequence)it).length() <= 0) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                String string3 = string;
                String string4 = string3;
                if (string4 == null) return null;
                string = string4;
                CustomTrustManagerHelper customTrustManagerHelper = this.this$0;
                String it2 = string;
                boolean bl3 = false;
                KeyStore keyStore = CustomTrustManagerHelper.Companion.createKeyStore(it2);
                CustomTrustManagerHelper.access$getDefaultTrustManagerFactory$p(customTrustManagerHelper).init(keyStore);
                TrustManager[] trustManagerArray = CustomTrustManagerHelper.access$getDefaultTrustManagerFactory$p(customTrustManagerHelper).getTrustManagers();
                Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getTrustManagers(...)");
                X509TrustManager x509TrustManager = CustomTrustManagerHelper.Companion.getX509Manager(trustManagerArray);
                return x509TrustManager;
            }
        }));
        this.defaultTrustManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<X509TrustManager>(this){
            final /* synthetic */ CustomTrustManagerHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final X509TrustManager invoke() {
                CustomTrustManagerHelper.access$getDefaultTrustManagerFactory$p(this.this$0).init((KeyStore)null);
                TrustManager[] trustManagerArray = CustomTrustManagerHelper.access$getDefaultTrustManagerFactory$p(this.this$0).getTrustManagers();
                Intrinsics.checkNotNullExpressionValue((Object)trustManagerArray, (String)"getTrustManagers(...)");
                return CustomTrustManagerHelper.Companion.getX509Manager(trustManagerArray);
            }
        }));
    }

    public /* synthetic */ CustomTrustManagerHelper(String string, boolean bl, String string2, String string3, String string4, TrustManagerFactory trustManagerFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            TrustManagerFactory trustManagerFactory2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            Intrinsics.checkNotNullExpressionValue((Object)trustManagerFactory2, (String)"getInstance(...)");
            trustManagerFactory = trustManagerFactory2;
        }
        this(string, bl, string2, string3, string4, trustManagerFactory);
    }

    @NotNull
    public final List<X509TrustManager> getTrustManagers() {
        return this.trustManagers;
    }

    public final void buildTrustManagers() {
        X509TrustManager it;
        X509TrustManager x509TrustManager = this.getDefaultTrustManager();
        if (x509TrustManager != null) {
            it = x509TrustManager;
            boolean bl = false;
            this.trustManagers.add(it);
        }
        X509TrustManager x509TrustManager2 = this.getTrustStoreTrustManager();
        if (x509TrustManager2 != null) {
            it = x509TrustManager2;
            boolean bl = false;
            this.trustManagers.add(it);
        }
        X509TrustManager x509TrustManager3 = this.getCustomTrustManager();
        if (x509TrustManager3 != null) {
            it = x509TrustManager3;
            boolean bl = false;
            this.trustManagers.add(it);
        }
        if (this.isSelfSignedAllowed) {
            this.trustManagers.add(new SelfSignedTrustManager());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyStore loadTrustStoreFromFile() {
        KeyStore keyStore;
        String string = this.trustStorePath;
        if (string != null) {
            KeyStore keyStore2;
            String storePath = string;
            boolean bl = false;
            try {
                char[] password;
                String string2 = this.trustStoreType;
                if (string2 == null) {
                    string2 = KeyStore.getDefaultType();
                }
                String storeType = string2;
                logger.debug("Loading truststore from " + storePath + " with type " + storeType);
                KeyStore keyStore3 = KeyStore.getInstance(storeType);
                String string3 = this.trustStorePassword;
                if (string3 != null) {
                    char[] cArray = string3.toCharArray();
                    v4 = cArray;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                } else {
                    v4 = password = null;
                }
                if (((CharSequence)storePath).length() > 0) {
                    Closeable closeable = new FileInputStream(new File(storePath));
                    Throwable throwable = null;
                    try {
                        FileInputStream inputStream = (FileInputStream)closeable;
                        boolean bl2 = false;
                        keyStore3.load(inputStream, password);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else {
                    keyStore3.load(null, password);
                }
                keyStore2 = keyStore3;
            }
            catch (Exception e) {
                logger.error("Failed to load truststore from " + storePath, (Throwable)e);
                keyStore2 = null;
            }
            keyStore = keyStore2;
        } else {
            keyStore = null;
        }
        return keyStore;
    }

    private final X509TrustManager getTrustStoreTrustManager() {
        Lazy lazy = this.trustStoreTrustManager$delegate;
        return (X509TrustManager)lazy.getValue();
    }

    private final X509TrustManager getCustomTrustManager() {
        Lazy lazy = this.customTrustManager$delegate;
        return (X509TrustManager)lazy.getValue();
    }

    private final X509TrustManager getDefaultTrustManager() {
        Lazy lazy = this.defaultTrustManager$delegate;
        return (X509TrustManager)lazy.getValue();
    }

    public CustomTrustManagerHelper() {
        this(null, false, null, null, null, null, 63, null);
    }

    public static final /* synthetic */ KeyStore access$loadTrustStoreFromFile(CustomTrustManagerHelper $this) {
        return $this.loadTrustStoreFromFile();
    }

    public static final /* synthetic */ TrustManagerFactory access$getDefaultTrustManagerFactory$p(CustomTrustManagerHelper $this) {
        return $this.defaultTrustManagerFactory;
    }

    public static final /* synthetic */ String access$getPath$p(CustomTrustManagerHelper $this) {
        return $this.path;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stackhawk/ssl/CustomTrustManagerHelper$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createCertificates", "", "Ljava/security/cert/X509Certificate;", "path", "", "createKeyStore", "Ljava/security/KeyStore;", "getX509Manager", "Ljavax/net/ssl/X509TrustManager;", "trustManagers", "", "Ljavax/net/ssl/TrustManager;", "([Ljavax/net/ssl/TrustManager;)Ljavax/net/ssl/X509TrustManager;", "talon-http"})
    @SourceDebugExtension(value={"SMAP\nCustomTrustManagerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomTrustManagerHelper.kt\ncom/stackhawk/ssl/CustomTrustManagerHelper$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,106:1\n1855#2,2:107\n4098#3,11:109\n*S KotlinDebug\n*F\n+ 1 CustomTrustManagerHelper.kt\ncom/stackhawk/ssl/CustomTrustManagerHelper$Companion\n*L\n40#1:107,2\n45#1:109,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Collection<X509Certificate> createCertificates(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream certStream = new ByteArrayInputStream(FilesKt.readBytes((File)new File(path)));
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(certStream);
            Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.Collection<java.security.cert.X509Certificate>");
            return collection;
        }

        @NotNull
        public final KeyStore createKeyStore(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            logger.debug("Creating key store");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            Collection<X509Certificate> certs = this.createCertificates(path);
            Iterable $this$forEach$iv = certs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                X509Certificate it = (X509Certificate)element$iv;
                boolean bl = false;
                keyStore.setCertificateEntry(UUID.randomUUID().toString(), it);
            }
            Intrinsics.checkNotNull((Object)keyStore);
            return keyStore;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final X509TrustManager getX509Manager(@NotNull TrustManager[] trustManagers) {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)trustManagers, (String)"trustManagers");
            TrustManager[] $this$filterIsInstance$iv = trustManagers;
            boolean $i$f$filterIsInstance = false;
            TrustManager[] trustManagerArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof X509TrustManager)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (X509TrustManager)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

