/*
 * Decompiled with CFR 0.152.
 */
package com.github.brymck.gsondeepmerge;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GsonDeepMerge {
    public <T> T deepMerge(@NotNull Gson gson, @NotNull T original, @NotNull T update, @NotNull Class<T> classOfT) throws IllegalStateException {
        JsonObject originalJsonObject = gson.toJsonTree(original).getAsJsonObject();
        JsonObject updateJsonObject = gson.toJsonTree(update).getAsJsonObject();
        JsonObject mergedJsonObject = this.deepMerge(originalJsonObject, updateJsonObject);
        return (T)gson.fromJson((JsonElement)mergedJsonObject, classOfT);
    }

    public JsonObject deepMerge(@NotNull JsonObject originalObject, @NotNull JsonObject updateObject) throws IllegalStateException {
        return this.deepMergeInPlace(originalObject.deepCopy(), updateObject);
    }

    private JsonObject deepMergeInPlace(@NotNull JsonObject originalObject, @NotNull JsonObject updateObject) throws IllegalStateException {
        for (Map.Entry entry : updateObject.entrySet()) {
            String updateKey = (String)entry.getKey();
            JsonElement updateValue = (JsonElement)entry.getValue();
            if (originalObject.has(updateKey)) {
                JsonElement originalValue = originalObject.get(updateKey);
                if (this.typesConflict(originalValue, updateValue)) {
                    String message = String.format("Type of %s and %s conflict", originalValue, updateValue);
                    throw new IllegalStateException(message);
                }
                if (originalValue.isJsonArray() && updateValue.isJsonArray()) {
                    JsonArray originalArray = originalValue.getAsJsonArray();
                    JsonArray updateArray = updateValue.getAsJsonArray();
                    for (JsonElement it : updateArray) {
                        originalArray.add(it);
                    }
                    continue;
                }
                if (originalValue.isJsonObject() && updateValue.isJsonObject()) {
                    this.deepMergeInPlace(originalValue.getAsJsonObject(), updateValue.getAsJsonObject());
                    continue;
                }
                if (updateValue.isJsonNull()) continue;
                originalObject.add(updateKey, updateValue);
                continue;
            }
            originalObject.add(updateKey, updateValue);
        }
        return originalObject;
    }

    private boolean typesConflict(@NotNull JsonElement element1, @NotNull JsonElement element2) {
        if (element1.isJsonNull()) {
            return false;
        }
        if (element2.isJsonNull()) {
            return false;
        }
        if (element1.isJsonObject()) {
            return !element2.isJsonObject();
        }
        if (element1.isJsonArray()) {
            return !element2.isJsonArray();
        }
        if (element2.isJsonPrimitive()) {
            JsonPrimitive primitive1 = element1.getAsJsonPrimitive();
            JsonPrimitive primitive2 = element2.getAsJsonPrimitive();
            if (primitive1.isBoolean()) {
                return !primitive2.isBoolean();
            }
            if (primitive1.isNumber()) {
                return !primitive2.isNumber();
            }
            return !primitive2.isString();
        }
        return true;
    }
}

