### Writing markdown documentation for proto messages
In order to simplify the documentation process for our protos, namely the scan configuration proto, the markdown files can be stored in the /docs directory and can be individually modified/created for specific fields on a proto message. The markdown file is reference via custom proto extension to read the contents of the file and inject it into the `markdownDescription` data. 

To create a new markdown file for a proto message field, follow these steps:
1. Find the field you want to add/modify documentation for. The filename should follow the syntax `{parentObject?.}fieldName`
    - Note: this is not the same as the config path. For example, the `applicationId` field in the `AppConf` message is stored in the file `appConf.applicationId.md`, since the parent object is `appConf` in the proto.
2. Create a new markdown file in the `/docs` directory with the filename you determined in step 1, if it doesn't already exist.
3. Write the documentation in the markdown file. The documentation should be written in markdown format. 
    - Note: The markdown file should not contain any front matter, such as `---`, as this will cause the documentation to not be read correctly.
4. Add the `markdown_ref` extension to the field if it doesn't already exist. It should look like this:
    ```proto
    string applicationId = 1 [(hawk.markdown_ref) = "scanconfig/appConf.applicationId.md"];
    ```
   The root is the `/docs` directory, so the path should be relative to that.


#### That should be it. Next time hawkscan is released the schema will be regenerated and deployed with the markdown documentation included.