Define how HawkScan should authenticate as a user to your application. This section includes options for various authentication methods like username/password, OAuth, external tokens, or custom scripts:

* Logged In/Out Indicators (`loggedInIndicator`, `loggedOutIndicator`): Regex patterns to check session status (required if auth token is not JWT).
* Auth(N) (`usernamePassword`): Form-based login with properties like loginPath, usernameField, passwordField, and optional otherParams.
* Auth(Z) (`tokenAuthorization`): Session management using type, value, and tokenType.
* Token Extraction (`tokenExtraction`): Defines how to retrieve the token from responses.
* Test Path (`testPath`): Verifies login by checking an authenticated endpoint.

Many other options for a wide variety of authentication methods are available. For a full breakdown of available configurations, see [Authenticated Scanning Documentation](https://docs.stackhawk.com/hawkscan/authenticated-scanning/).