Configure the policy to be applied for the scan, optionally specifying which plugins to include or exclude. **Note**: Works for scan policies created with [Organization Policy Management](https://docs.stackhawk.com/web-app/policy-management/#organization-policy-management).

* `name`: Required. The unique name of the scan policy to use (e.g., `CUSTOM_POLICY`).
* `excludePluginIds`: List of plugin IDs to exclude from the named scan policy.
* `includePluginIds`: List of plugin IDs to include that are not already part of the named scan policy.

**Note**: To specify a [StackHawk default policy](https://docs.stackhawk.com/web-app/policy-management/policy-management-defaults.html), use `hawk.scan.policyName`.

**Example:**
```yaml
app:
  scanPolicy:
    name: CUSTOM_POLICY
    includePluginIds:
      - 90036
    excludePluginIds:
      - 90035
```

For more details, see our documentation for [Organization Policy Management](https://docs.stackhawk.com/web-app/policy-management/#organization-policy-management).