Define custom variables to be used during scanning. This section allows you to parameterize scan behavior or inject dynamic values into requests:

* **Key-Value Pairs**: Specify custom variables as key-value pairs to replace placeholders in requests or configurations.
* **Scopes**: Apply variables globally or limit them to specific APIs, endpoints, or operations.
* **Environment Overrides**: Use environment variables to dynamically set or override custom values during scans.

**Example:**
```yaml
customVariables:
  - field: firstName
    values:
      - customFirstName1
      - customFirstName2
  - field: lastName
    values:
      - customLastName1
      - customLastName2
```

For details on how to configure custom variables, see our documentation for the corresponding API type (e.g., OpenAPI, GraphQL, or gRPC).